import random
from math import *

table = []
X = "x"
Y = "y"
bmb = -1
ran = 5
w = 27

def get(x, y):
	return table[y][x]

def distance(a, b):
	xa, ya = a[:2]
	xb, yb = b[:2]
	dx = xb - xa
	dy = yb - ya
	return (dx, dy)


def no_wall_x(a, b):
	mex, mey = a[:2]
	dx, dy = distance(a, b)
	xs = int(copysign(1, dx))
	ys = int(copysign(1, dy))
	for x in range(xs, dx+xs, xs):
		if get(x+mex, mey) == bmb:
			return False
	for y in range(ys, dy+ys, ys):
		if get(dx+mex, y+mey) == bmb:
			return False
	return True

def no_wall_y(a, b):
	mex, mey = a[:2]
	dx, dy = distance(a, b)
	xs = int(copysign(1, dx))
	ys = int(copysign(1, dy))
	for y in range(ys, dy+ys, ys):
		if get(mex, y+mey) == bmb:
			return False
	for x in range(xs, dx+xs, xs):
		if get(x+mex, dy+mey) == bmb:
			return False
	return True

def no_wall(a, b):
	if no_wall_x(a, b):
		return True, X
	if no_wall_y(a, b):
		return True, Y
	return False, "D"


def zarib(a, b):
	mex, mey = a[:2]
	dx, dy = distance(a, b)
	d = abs(dx) + abs(dy)
	return get(*(b[:2])) / d

def check_all(me):
	zs = dict()
	mex, mey, mes = me
	for x in range(mex-ran+1, mex+ran):
		for y in range(mey-ran+1, mey+ran):
			if 0 <= x < w and 0 <= y < w and (not (x == mex and y == mey)):
				p = [x, y]
				nw = no_wall(me, p)
				if nw[0]:
					p.append(nw[1])
					if get(*(p[:2])) > 0:
						p = tuple(p)
						zs[p] = zarib(me, p)
	return zs

def best_dest(me):
	global ran
	zs = check_all(me)
	it = list(zs.items())
	while len(it) == 0:
		ran += 1
		zs = check_all(me)
		it = list(zs.items())
	bk = it[0][0]
	bv = it[0][1]
	for key, val in it[1:]:
		if val > bv:
			bv = val
			bk = key
	return bk
x = open("input.txt")
mex, mey, mes = x.readline().split()
mex = int(mex)
mey = int(mey)
mes = float(mes)
me = mex, mey, mes
enx, eny, ens = x.readline().split()
cycles = int(x.readline())
memory = x.readline()
for i in range(27):
	line = x.readline()
	line = line.split()
	line = list(map(int, line))
	for j, k in enumerate(line):
		if k == -2:
			line[j] = bmb
	table.append(line)

# def out(*v):
# 	with open("std_out.txt", 'a') as std_out:
# 		print(*v, file=std_out)

def move(bk):
	rasta = bk[2]
	dx, dy = distance(me, bk)
	if rasta == X:
		if dx > 0:
			print("right")
		elif dx < 0:
			print("left")
		else:
			if dy > 0:
				print("down")
			elif dy < 0:
				print("up")
	elif rasta == Y:
		if dy > 0:
			print("down")
		elif dy < 0:
			print("up")


move(best_dest(me))
print('^_^')
